function Message() {

    let _subscribers = {};

    _init();

    function _init() {
        chrome.storage.local.onChanged.addListener(function (changes) {
            if (changes.message === undefined || changes.message.newValue === undefined || changes.message.newValue === null) {
                return;
            }
            if (changes.message.newValue) {
                let event = changes.message.newValue;
                _emit(event);
                chrome.storage.local.set({message: null});
            }
        });
    }

    function on(eventName, listener) {
        if (_subscribers[eventName] === undefined) {
            _subscribers[eventName] = [];
        }
        _subscribers[eventName].push(listener);
    }

    function off(eventName, listener) {
        if (_subscribers[eventName] === undefined) {
            return;
        }
        let keyToDelete = null;
        _subscribers[eventName].forEach((element, index) => {
            if (element === listener) {
                keyToDelete = index;
            }
        });
        if (keyToDelete !== null) {
            _subscribers[eventName].splice(keyToDelete, 1);
        }
    }

    function _emit(event) {
        const eventName = event.name;
        if (_subscribers[eventName]) {
            for (let listener of _subscribers[eventName]) {
                listener(event);
            }
        }
    }

    function emit(eventName, data) {
        const event = {name: eventName, data};
        chrome.storage.local.set({message: event});
    }

    return {on, off, emit};
}

const message = new Message();
