// Для работы с формой настроек

const notification = {
    notify: function () {
    }
}

/**
 * получить данные из манифеста плагина.
 * @param key
 * @returns {*}
 */
function getManifestKey(key) {
    const manifest = chrome.runtime.getManifest();
    return manifest[key];
}

$('#save').on('click', function () {
    settings.setMany(getData());
    settings.save();
});

function getData() {
    let data = {}
    let $form = $('#settingsForm');
    $form.find('input[type!="button"]').each(function (index, item) {
        let $item = $(item);
        let value = $item.val();
        if ($item.attr('type') === 'checkbox') {
            value = $item.prop('checked')
        }
        data[$item.attr('name')] = value;
        addFormField(data, $item);
    });
    $form.find('select').each(function (index, item) {
        let $item = $(item);
        data[$item.attr('name')] = $item.val();
        addFormField(data, $item);
    });
    return data;
}

function addFormField(data, $item) {
    if (!data['form_fields']) {
        data['form_fields'] = [];
    }
    if (!data['form_fields_type']) {
        data['form_fields_type'] = {};
    }
    if ($item.parents('.form_fields')) {
        data['form_fields'].push($item.attr('name'));
        data['form_fields_type'][$item.attr('name')] = $item.attr('type');
    }
}

function setSettingToForm() {
    let currentSettings = settings.getAll();
    for (let name in currentSettings) {
        let value = currentSettings[name];
        let $elem = $('[name="' + name + '"]');
        if ($elem.length > 0) {
            if ($elem.attr('type') === 'hidden') {
                continue;
            }
            if ($elem.attr('type') === 'checkbox') {
                $elem.prop('checked', value);
            } else {
                $elem.val(value);
            }
        }
    }
}

function start() {
    utils.wait(() => settings !== undefined && settings.ready())
        .then(main);
}

function setManifestInfoToTemplate() {
    const name = $('[data-manifest-name]');
    const version = $('[data-manifest-version]');

    name.each(function () {
        $(this).text(getManifestKey('name'));
    });

    version.each(function () {
        $(this).text(getManifestKey('version'));
    });
}

function fillBadgeNumberSection() {
    let countElInSection = [];
    let elInSection = $('[data-number-section]');

    if (elInSection.length > 0) {
        elInSection.each(function () {
            let $this = $(this);
            let numberSection = $this.data('number-section');
            countElInSection[numberSection] = $this.children().length;
        })
    }

    if (countElInSection.length > 0) {
        let badgeNumberSection = $('[data-badge-number-section]');
        badgeNumberSection.each(function () {
            let $this = $(this);
            let numberBadgeSection = $this.data('badge-number-section');

            $this.text(countElInSection[numberBadgeSection]);
        });
    }
}

function main() {
    setSettingToForm();
    setManifestInfoToTemplate();
    fillBadgeNumberSection();
}

start();
