async function start() {
    await utils.wait(() => settings !== undefined);

    if (!settings.ready()) {
        settings.on('ready', () => {
            main();
        })
        return;
    }
    main();
}

function main() {
    let pages = {};
    const detectedPages = detect();
    for (const pageName of detectedPages) {
        if (window[pageName + '_page'] !== undefined) {
            pages[pageName] = window[pageName + '_page']();
        }
    }
    $(function () {
        const detectedPages = detect();
        for (const pageName of detectedPages) {
            if (pages[pageName] === undefined && window[pageName + '_page'] !== undefined) {
                pages[pageName] = window[pageName + '_page']();
            }
        }
        for (const pageName in pages) {
            const page = pages[pageName];
            if (page && page['onReady'] !== undefined && typeof page.onReady === 'function') {
                page.onReady();
            }
        }
    })
}

start();