function issue_page() {

    let _returnButtonHandlerInjected = false;
    let _attachmentImagesHandlerInjected = false;

    _init();

    function _init() {
        _updateButtons();

        _eraseTabs();
        _eraseActions();
        _eraseHeaders();
        _eraseBlocks();
        _eraseHistoryIDs();

        _compactPeople();
        _compactPreviousAssignee();
        _compactAttachmentImages();
        _compactHistory();

        _colorizeComments();
        _colorizeHistory();
        _alignHistory();
    }

    function onReady() {
        _injectCopyButtons();
        _injectReturnButton();

        _rebuildPeople();
        _rebuildPreviousAssignee();
        _rebuildAttachmentImages();
        _rebuildHistory();

        _unfoldComments();

        if (settings.get('global_favoriteUsers')) {
            favorite.updateIssuePage();
        }
        //TODO перевести в свой класс для всех работ с гитом
        if (settings.get('git_hideCommitContent')) {
            utils.writeStyles(
                '.bbb-gp-codereview-commit__files-and-branches.gp-content {display:none}' +
                '.gp-panel {cursor:pointer;}' +
                '.gp-panel:hover {background-color: #eee;}'
            );
            $('body').on('click', '.gp-panel', function () {
                $(this).find('.gp-content').toggle();
            });
        }

        if (settings.get('issue_unwrapTransitions')) {
            eraser.eraseBySelector('li:has(> div > #opsbar-transitions_more)');
            _unwrapTransitions();
        }
    }

    function _compactPeople() {
        if (!settings.get('issue_compactPeople')) {
            return;
        }
        utils.writeStyles(
            '#assignee-val > span, #reporter-val > span { white-space: nowrap;}' +
            '#assignee-val, #reporter-val {overflow: hidden;}'
        );
    }

    function _rebuildPeople() {
        if (!settings.get('issue_compactPeople')) {
            return;
        }
        $('.assign-to-me-link:has(#assign-to-me):not(.plugin_issue_rebuild_people)')
            .addClass('plugin_issue_rebuild_people')
            .css({display: 'inline'})
            .appendTo('.people-details dl:has(#assignee-val) dt');
        setTimeout(_rebuildPeople, 1000);
    }

    function _unwrapTransitions() {
        const transitionMenu = $('#opsbar-opsbar-transitions:not(.plugin_issue_unwrap_transitions)');
        if (transitionMenu.length) {
            transitionMenu.addClass('plugin_issue_unwrap_transitions');
            $('#opsbar-transitions_more_drop li').each(function () {
                const $node = $(this);
                $node.find('a').addClass('toolbar-trigger');
                $node
                    .removeClass('aui-list-item')
                    .addClass('toolbar-item')
                    .appendTo(transitionMenu);
            });
            $('#opsbar-transitions_more_drop aui-item-link a').each(function () {
                const $node = $(this);
                $node.addClass('toolbar-trigger');
                const actionId = utils.getQuery('action', $node.attr('href'));
                $node
                    .attr('id', 'action_id_' + actionId)
                    .removeClass('aui-list-item')
                    .addClass('aui-button')
                    .addClass('toolbar-trigger')
                    .addClass('issueaction-workflow-transition')
                    .removeAttr('tabindex')
                    .removeAttr('role')
                    .appendTo(transitionMenu);
            });
            $('#opsbar-transitions_more').remove();
        }

        setTimeout(_unwrapTransitions, 1000);
    }

    function _updateButtons() {
        let selectorsToErase = [];
        if (settings.get('issue_shortenButtons')) {
            selectorsToErase.push(
                '#edit-issue .trigger-label',
                '#comment-issue .trigger-label',
                '#viewissue-export .dropdown-text',
                '#opsbar-operations_more .dropdown-text',
            );

            utils.writeStyles('#opsbar-operations_more{ height: 30px;}');
        }
        if (settings.get('issue_eraseRightColumnButtons')) {
            selectorsToErase.push(
                '.toolbar-split-right:has([id="opsbar-jira.issue.tools"])',
                '.aui-toolbar2-secondary:has([id="opsbar-jira.issue.tools"])'
            );
        }
        if (settings.get('issue_eraseAssignButton')) {
            selectorsToErase.push('#opsbar-opsbar-operations li:has(#assign-issue)');
            utils.writeStyles(
                '#opsbar-opsbar-operations li:nth-of-type(2) a {border-left-width: 1px; border-radius:3px;}' +
                '#opsbar-opsbar-operations li:nth-of-type(2) a:hover {margin-left:0;}'
            );
        }
        if (selectorsToErase.length) {
            eraser.eraseBySelector(selectorsToErase);
        }
    }

    function _injectCopyButtons() {
        if (!settings.get('issue_copyNumber')) {
            return;
        }
        //TODO: хорошо бы на MutationObserver переделать
        jiraCopy.injectIssueCopyButtons();
        setTimeout(_injectCopyButtons, 1000);
    }

    function _injectReturnButton() {
        if (!settings.get('issue_injectReturnButton')) {
            return;
        }

        if (!_returnButtonHandlerInjected) {
            $('body').on('click', '#plugin_issue_return_button', function () {
                const $user = $('#reporter-val .user-hover');
                const image = $user.find('img').attr('src');
                const name = $user.attr('rel');
                const label = $user.text().trim();
                $('#assignee-val').trigger('click');
                setTimeout(() => {
                    $('#assignee-single-select input').val(label);
                    $('#assignee-form .aui-ss-entity-icon').attr('src', image);
                    if (!$('#assignee-group-suggested [value="' + name + '"]').length) {
                        $('<option>' + label + '</option>').val(name).appendTo('#assignee-group-suggested');
                    }
                    $('#assignee').val(name);
                    $('#assignee-form [type="submit"]').trigger('click');
                }, 400);
            });
            _returnButtonHandlerInjected = true;
        }
        //TODO: хорошо бы на MutationObserver переделать
        if (
            $('#reporter-val').length
            && !$('#plugin_issue_return_button').length
            && $('#reporter-val .user-hover').attr('rel') !== $('#assignee-val .user-hover').attr('rel')
        ) {
            $('<span> Вернуть</span>')
                .attr('id', 'plugin_issue_return_button')
                .appendTo('dl:has(> dd> #reporter-val) dt');
        }
        setTimeout(_injectReturnButton, 1000);
    }

    function _eraseTabs() {
        if (settings.get('git_eraseIssueTabSummary')) {
            eraser.eraseBySelector(
                'a[href$="?page=com.xiplink.jira.git.jira_git_plugin:git-summary-tabpanel"]',
                eraser.getTabsToErase('[data-id="git-summary-tabpanel"]')
            );
        }
        if (settings.get('git_eraseIssueTabsCommits')) {
            eraser.eraseBySelector(
                'a[href$="?page=com.xiplink.jira.git.jira_git_plugin:git-commits-tabpanel"]',
                eraser.getTabsToErase('[data-id="git-commits-tabpanel"]')
            );
        }
    }

    function _eraseActions() {
        let selectorsToErase = [];
        if (settings.get('project_eraseCreatingActions')) {
            selectorsToErase.push('.aui-dropdown2-section:has(#create_ticket1_0)');
        }
        if (settings.get('project_eraseScheduleIssue')) {
            selectorsToErase.push('.aui-dropdown2-section:has(#schedule-issue-link)');
        }
        if (selectorsToErase.length) {
            eraser.eraseBySelector(selectorsToErase);
        }
    }

    function _eraseHeaders() {
        if (!settings.get('issue_eraseUnnecessaryHeaders')) {
            return;
        }
        eraser.eraseBySelector(
            '#details-module_heading',
            '#peoplemodule_heading',
            '#datesmodule_heading',
            '#attachmentmodule_heading',
            '#activitymodule_heading',
        )
    }

    function _eraseBlocks() {
        if (settings.get('issue_eraseAgileBlock')) {
            eraser.eraseBySelector('#greenhopper-agile-issue-web-panel');
        }
    }

    function _compactPreviousAssignee() {
        if (!settings.get('issue_compactAssigneeHistory')) {
            return;
        }
        eraser.eraseBySelector('#assignee-history-tab .mod-content tr td:nth-child(1)');
    }

    function _rebuildPreviousAssignee() {
        if (!settings.get('issue_compactAssigneeHistory')) {
            return;
        }
        let assigneeLIst = {};

        $('#assignee-history-tab .mod-content tr').each(function () {
            const $tr = $(this);
            const $imgCell = $tr.find('td:eq(1)');
            const $assignee = $tr.find('td:eq(2)');

            const href = $imgCell.attr('href');
            const rel = utils.getQuery('name', href);

            if (assigneeLIst[rel]) {
                $tr.remove();
                return;
            }
            assigneeLIst[rel] = true;

            const $aImg = $('<a>')
                .attr('href', href)
                .addClass('user-hover')
                .attr('rel', rel)
                .append($imgCell.html());
            $imgCell.html($aImg);

            const $aName = $('<a>' + $assignee.text() + '</a>')
                .attr('href', href)
                .addClass('user-hover')
                .attr('rel', rel)
            $assignee.html($aName);
        })
    }

    function _compactAttachmentImages() {
        if (!settings.get('issue_compactAttachmentImages')) {
            return;
        }
        utils.writeStyles('.image-wrap img{max-width: 500px;}');
    }

    function _rebuildAttachmentImages() {
        if (!settings.get('issue_compactAttachmentImages')) {
            return;
        }
        $('#descriptionmodule img').each(function () {
            let $image = $(this);
            if ($image.parents('a').length) {
                return;
            }
            let $a = $('<a href="#" title="Кликните что бы увидеть оригинальный размер">')
                .append($image.clone())
                .on('click', function () {
                    $(this).find('img').toggleClass('force-no_max_width');
                });
            $image.replaceWith($a);
        });

        if (!_attachmentImagesHandlerInjected) {
            $('body').on('click', '#activitymodule .image-wrap img', function (event) {
                let $image = $(this);
                if ($image.parents('a').length) {
                    return;
                }
                $image.toggleClass('force-no_max_width');
            });
            _attachmentImagesHandlerInjected = true;
        }
        setTimeout(_rebuildAttachmentImages, 1000);
    }

    function _unfoldComments() {
        if (!settings.get('issue_unfoldComments')) {
            return;
        }
        const $moreComments = $('#issue_actions_container > .message-container > a.collapsed-comments');
        if ($moreComments.length) {
            $moreComments[0].click();
        }
        setTimeout(_unfoldComments, 2000);
    }

    function _getStatusClass(title) {
        switch (title) {
            case 'Задача':
                return 'task';
            case 'Бэклог':
                return 'backlog';
            case 'Отменена':
            case 'Выполнена':
                return 'final';
            default:
                return 'default';
        }
    }

    function _colorizeComments() {
        if (!settings.get('issue_colorizeComments')) {
            return;
        }
        utils.writeStyles(
            '#activitymodule #issue_actions_container [id^="comment"] .action-body.flooded {' +
            '    padding: 7px;' +
            '    border: 1px solid #f1f1f1;' +
            '    border-radius: 0 10px 10px 10px;' +
            '    margin: 0 20px 0 0;' +
            '    background-color: #f1f1f1;' +
            '    display: inline-block;' +
            '}'
        );
    }

    function _colorizeHistory() {
        if (!settings.get('issue_colorizeHistory')) {
            return;
        }
        utils.writeStyles(
            '#activitymodule #issue_actions_container [id^="issuecreated-"] {' +
            '    background-color: #d6ffcc;' +
            '}' +
            '.changehistory.action-body table tr:hover td {' +
            '    background-color: #eee;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-bubble-avatar {' +
            '    height: 20px;' +
            '    width: 20px;' +
            '    padding: 0;' +
            '    border: none;' +
            '    border-radius: 50%;' +
            '    margin-top: 0;' +
            '    margin-right: 2px;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-bubble-avatar img {' +
            '    width: 20px !important;' +
            '    height: 20px !important;' +
            '    padding: 0;' +
            '    box-sizing: border-box;' +
            '    border-radius: 50%;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-bubble-body {' +
            '    margin-left: 0;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-panel-title .gp-bubble-user {' +
            '    font-weight: 400;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-panel-arrow {' +
            '    display: none;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-panel {' +
            '    border-color: #fdc77b;' +
            '    background-color: #fff5ec;' +
            '    border-radius: 0 10px 10px 10px;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-panel:hover {' +
            '    background-color: #fff2e5;' +
            '}'
        );
    }

    function _alignHistory() {
        if (!settings.get('issue_alignHistory')) {
            return;
        }
        utils.writeStyles(
            '#activitymodule #issue_actions_container .issue-data-block .actionContainer {' +
            '    padding-left: 0;' +
            '}' +
            '#activitymodule #issue_actions_container .issue-data-block .action-head button.aui-iconfont-expanded,' +
            '#activitymodule #issue_actions_container .issue-data-block .action-head button.aui-iconfont-collapsed {' +
            '    margin-left: -22px;' +
            '}'
        );
    }

    function _compactHistory() {
        if (!settings.get('issue_compactHistory')) {
            return;
        }

        utils.writeStyles(
            '.action-details .date' +
            '{' +
            '   float: right;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-panel-title .gp-light {' +
            '    float: right;' +
            '    color: #172b4d;' +
            '    font-size: 14px;' +
            '}' +
            '#activitymodule #issue_actions_container .issue-data-block .aui-avatar-inner {' +
            '    width: 20px;' +
            '    height: 20px;' +
            '}' +
            '#activitymodule #issue_actions_container .issue-data-block .user-avatar {' +
            '    padding: 4px 0 0 23px;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-panel-arrow {' +
            '    display: none;' +
            '}' +
            '.bbb-gp-codereview-commit__commit.gp-commit.gp-data-block .gp-panel {' +
            '    clear: both;' +
            '}'
        );
    }

    function _rebuildHistory() {
        if (
            !settings.get('issue_compactHistory')
            && !settings.get('issue_colorizeHistory')
            && !settings.get('issue_colorizeComments')
        ) {
            return;
        }

        if (settings.get('issue_compactHistory')) {
            $('.bbb-gp-codereview-commit__repo.gp-commit-group.gp-data-block').remove();
            $('.action-details').each(function () {
                let $node = $(this);
                let html = $node.html();

                html = html
                    .replace('добавил(а) комментарий  -', '&nbsp')
                    .replace('внес изменения -', '&nbsp')
                    .replace('создал задачу  -', 'создал(а) задачу')
                    .replace(' - ', '')
                ;
                if (html !== $node.html()) {
                    $node.html(html);
                }
            });

            $('[id^="changehistory-"]').reverse().each(function () {
                const $current = $(this);
                const $next = $current.prev('[id^="changehistory-"]');
                if (!$next.length) {
                    return;
                }
                const currentAuthor = $current.find('.action-details .user-hover').attr('rel');
                if (currentAuthor !== $next.find('.action-details .user-hover').attr('rel')) {
                    return;
                }
                const currentTime = $current.find('.action-details .date').attr('title');
                if (currentTime !== $next.find('.action-details .date').attr('title')) {
                    return;
                }
                $current.find('tr').appendTo($next.find('table'));
                $current.remove();
            });

            $('[id^="changehistory-"], .bbb-gp-codereview-commit__commit.gp-commit.gp-data-block, [id^="comment-"]').reverse().each(function () {

                const $current = $(this);
                const $next = $current.prevAll('[id^="changehistory-"], .bbb-gp-codereview-commit__commit.gp-commit.gp-data-block, [id^="comment-"]').first();
                if (!$next.length) {
                    return;
                }
                const currentAuthor = $current.find('.action-details .user-hover, .bbb-gp-userhover-trigger').attr('rel');
                if (!currentAuthor) {
                    return;
                }
                const nextAuthor = $next.find('.action-details .user-hover, .bbb-gp-userhover-trigger').attr('rel');
                if (currentAuthor !== nextAuthor) {
                    return;
                }
                const name = $current.find('.action-details .user-hover, .bbb-gp-userhover-trigger').last().text();
                $current.addClass('prev-mine').attr('title', 'Автор: ' + name);
                $next.addClass('next-mine');
            });
        }

        if (settings.get('issue_colorizeComments')) {
            let me = jira.getMe();

            $('#activitymodule #issue_actions_container [id^="comment"]').each((index, node)=>{
                let $comment = $(node);
                if ($comment.find('.action-details .user-hover').attr('rel') === me) {
                    $comment.addClass('my-comment');
                }
            });
        }

        if (settings.get('issue_colorizeHistory')) {
            $('[id^="changehistory-"] .changehistory table tr td:first-child').reverse().each(function () {
                let $node = $(this);

                if ($node.text().trim() === 'Исполнитель') {
                    let $row = $node.parent();
                    $row.find('span.hist-value').remove();
                    let from = $row.find('td:eq(1)').text().trim();
                    let to = $row.find('td:eq(2)').text().trim();
                    let span = $('<div class="assignee">').html('' +
                        '<span>' + from + '</span>' +
                        '<span> ➡ </span>' +
                        '<span>' + to + '</span>'
                    );
                    $row.parents('.changehistory.action-body').prepend(span);
                    $row.remove();
                }

                if ($node.text().trim() === 'Статус') {
                    let $row = $node.parent();
                    $row.find('span.hist-value').remove();
                    let from = $row.find('td:eq(1)').text().trim();
                    let to = $row.find('td:eq(2)').text().trim();
                    let span = $('<div class="status">').html('' +
                        '<span><span class="aui-lozenge ' + _getStatusClass(from) + '">' + from + '</span></span>' +
                        '<span> ➡ </span>' +
                        '<span><span class="aui-lozenge ' + _getStatusClass(to) + '">' + to + '</span></span>'
                    )
                    $row.parents('.changehistory.action-body').prepend(span);
                    $row.remove();
                }
            });
        }
        setTimeout(_rebuildHistory, 2000);
    }

    function _eraseHistoryIDs() {
        if (!settings.get('issue_hideHistoryIDs')) {
            return;
        }
        utils.writeStyles(
            '.hist-value {' +
            '    display: none;' +
            '}'
        );

    }

    return {onReady}
}
