function dashboard_page() {

    _init();

    function _init() {
        _compactFilterResults();
        if (settings.get('dashboard_eraseHeader')) {
            eraser.eraseBySelector('.aui-page-header');
            utils.writeStyles('.layout.layout-aaa {padding-top:5px !important;}')
        }
        if (settings.get('dashboard_compactThreeColumns')) {
            utils.writeStyles(
                '.layout {padding-left: 0 !important; padding-right: 0 !important;}' +
                '.layout .column {margin-left: 1% !important;}' +
                '.layout-aaa .column {width: 32.1% !important;}' +
                '.layout .column .gadget, .layout .column .placeholder, .layout .column.empty .empty-text {margin-bottom: 10px !important;}'
            );
        }
        if (settings.get('dashboard_eraseFooter')) {
            eraser.eraseBySelector('#footer');
        }
    }

    function onReady() {
        _addToggleGadgetButton();
        _addCountToFilters();
    }

    function _addToggleGadgetButton() {
        if (!settings.get('dashboard_addToggleGadgetButton')) {
            return;
        }
        $('<span class="plugin-dashboard-toggle">')
            .on('click', function (e) {
                let $this = $(this);
                let $minButton = $this.parent().find('.gadget-menu .item-link.minimization');
                let $maxButton = $this.parent().find('.gadget-menu .item-link.maximization');
                if ($minButton.length) {
                    $minButton[0].click();
                } else {
                    $maxButton[0].click();
                }
            })
            .insertBefore('.dashboard-item-title');
    }

    function _addCountToFilters() {
        if (!settings.get('dashboard_addCountToFilters')) {
            return;
        }
        let missCount = 0;
        $('.dashboard-item-frame').each(function () {
            const $gadget = $(this);
            let $countLink = $gadget.find('.count-pagination .results-count a').clone();
            if (!$countLink.length) {
                $countLink = $gadget.find('.empty-results > a').clone().text('0');
                if (!$countLink.length) {
                    missCount++;
                    return;
                }
            }
            const $count = $('<span class="plugin-dashboard-counter">').append($countLink);
            const $header = $gadget.find('.dashboard-item-header h3');
            $header.find('.plugin-dashboard-counter').remove();
            $header.append($count);
        });
        const timeout = missCount ? 500 : 10000;
        setTimeout(_addCountToFilters, timeout); //содержимое гаджетов загружается аяксом и может обновляться спустя время
    }

    function _compactFilterResults() {
        if (!settings.get('dashboard_compact')) {
            return;
        }
        _eraseActionsInFilterResult();
        utils.writeStyles(
            '.search-results-dashboard-item.empty-results {padding:5px !important;}' +
            '.jira-issue-status-lozenge {max-width:60px !important;}' +
            '.headerrow-priority button {max-width: 16px; display:inline-block; overflow: hidden;}' +
            '.header-priority button {max-width: 16px; display:inline-block; overflow: hidden;}' +
            '.issuetable-header-sort-icon {display: none !important;}' +
            '.issuerow .components {max-width: 50px !important;}' +
            '.issuerow .components a {white-space: break-spaces !important;}' +
            '.issue-table>tfoot>tr>td, .issue-table>tbody>tr>td, .issue-table>thead>tr>th {padding:3px 4px 1px 4px !important;}' +
            '.issue-table {margin:0 !important;}'
        );
    }

    function _eraseActionsInFilterResult() {
        eraser.eraseBySelector(
            '.search-results-dashboard-item .issue-table thead .headerrow-actions',
            '.search-results-dashboard-item .issue-table tbody .issue_actions',
            '.issue-table-view .issue-table thead .issue-actions',
            '.issue-table-view .issue-table tbody .qrf-issue-actions',
        );
    }

    return {onReady};
}