function Favorite() {

    let _favorites = {
        users: [],
        projects: [], //пока не используется
    };

    let _ready = false;

    let _toggleIconTemplate =
        '<dl>' +
        '   <dt>В избранном:</dt>' +
        '   <dd id="plugin-favorite-user">' +
        '       <span>' +
        '           <span class="aui-icon aui-icon-small' +
        '               {{# isFavorite }}aui-iconfont-star{{/ isFavorite }}' +
        '               {{^ isFavorite }}aui-iconfont-unstar{{/ isFavorite }}"' +
        '           ></span>' +
        '           {{# isFavorite }}Добавлен{{/ isFavorite }}' +
        '           {{^ isFavorite }}Добавить{{/ isFavorite }}' +
        '       </span>' +
        '   </dd>' +
        '</dl>';

    const _userTemplate =
        '<span class="aui-avatar aui-avatar-small plugin-favorite-user" title="{{ label }}">' +
        '   <span class="aui-avatar-inner">' +
        '       <img src="{{ image }}" alt="{{ name }}">' +
        '       {{# letter }}' +
        '           <span class="plugin-favorite-user-letter">{{ letter }}</span>' +
        '       {{/ letter }}' +
        '   </span>' +
        '</span>';

    _init();

    function _init() {
        _load();
    }

    function _load() {
        chrome.storage.local.get(['favorites'], function (result) {
            if (result.favorites) {
                for (let type in _favorites) {
                    if (result.favorites[type]) {
                        _favorites[type] = result.favorites[type];
                    }
                }
            }
            _ready = true;
        });
    }

    function _save() {
        chrome.storage.local.set({favorites: _favorites});
    }

    async function updateProfilePage() {
        await utils.wait(() => _ready);

        const name = utils.getQuery('name');
        let isFavorite = _favorites.users.filter((record) => {
            return record.name === name;
        }).length === 1;

        let $favoriteSpan = $(Mustache.to_html(_toggleIconTemplate, {isFavorite}))
            .on('click', _toggleIsUserFavorite);
        let $nameRow = $('#up-d-username').parent();
        $nameRow.before($favoriteSpan);
    }

    function _toggleIsUserFavorite() {
        let userIndex = -1;
        let name = utils.getQuery('name');
        for (let index in _favorites.users) {
            if (_favorites.users[index].name === name) {
                userIndex = index;
                break;
            }
        }
        if (userIndex !== -1) {
            _favorites.users.splice(userIndex, 1);
        } else {
            _favorites.users.push({
                name,
                label: $('#up-d-fullname').text().trim(),
                image: $('#up-d-avatar img').attr('src'),
            });
        }
        $('#plugin-favorite-user').parent().remove();
        updateProfilePage();
        _save();
    }

    async function updateIssuePage() {
        await utils.wait(() => _ready);

        const $targetNode = $('#peopledetails #assignee-val:not(.plugin_favorite_updated)');
        if (!$targetNode.length) {
            setTimeout(updateIssuePage, 1000);
            return;
        }
        $targetNode.addClass('plugin_favorite_updated').css({display: 'block'});
        _favorites.users.sort((favoriteA, favoriteB) => {
            return favoriteA.name > favoriteB.name ? -1 : 1;
        });
        for (let userData of _favorites.users) {
            const user = {...userData};
            user.letter = user.image.indexOf(user.name) !== -1 ? false : user.label.substring(0, 1);
            const $span = $(Mustache.to_html(_userTemplate, user));
            $span
                .on('click', () => {
                    $('#assignee-val').trigger('click');
                    setTimeout(() => {
                        $('#assignee-single-select input').val(user.label);
                        $('#assignee-form .aui-ss-entity-icon').attr('src', user.image);
                        if (!$('#assignee-group-suggested [value="' + user.name + '"]').length) {
                            $('<option>' + user.label + '</option>').val(user.name).appendTo('#assignee-group-suggested');
                        }
                        $('#assignee').val(user.name);
                        $('#assignee-form [type="submit"]').trigger('click');
                    }, 400);
                })
                .insertAfter($targetNode)
        }
        setTimeout(updateIssuePage, 1000);
    }

    return {
        updateProfilePage,
        updateIssuePage,
    };
}

const favorite = new Favorite();
