function Eraser() {

    function eraseTeamCity() {
        eraseBySelector(
            '#teamcity',
            getProjectNavigationToErase('com.stiltsoft.jira.teamcity:filter-page'),
            getTabsToErase('[data-id="teamcity-issue-tabpanel"]')
        );
    }

    function eraseZephyr() {
        eraseBySelector(
            'div.aui-dropdown2-section:has( a[href^="/secure/CreateZephyrTest!default.jspa?"])',
            '#tm4j-trace-links-panel-issue-page',
            '#ghx-tab-com-kanoah-test-manager-tm4j-trace-links-panel-agile-board',
            '#THIRD_PARTY_TAB-nav:has([href="#ghx-tab-com-kanoah-test-manager-tm4j-trace-links-panel-agile-board"])',
            getMainNavigationToErase([
                '/secure/ZephyrWelcome.jspa',
                '/secure/Tests.jspa',
            ]),
            getProjectNavigationToErase([
                'com.thed.zephyr.je:zephyr-tests-page',
                'com.thed.zephyr.je:zephyr-atom-project-sidebar',
            ])
        );
    }

    function eraseGant() {
        eraseBySelector(
            '#issue-panel',
            getMainNavigationToErase('/secure/WBSGanttMain.jspa'),
            getProjectNavigationToErase('jp.ricksoft.plugins.wbsgantt-for-jira:wbsgantt-project')
        );
    }

    function eraseGit() {
        eraseBySelector(
            '#git-issue-webpanel',
            '.bbb-gp-codereview-commit__repo',
            '.bbb-gp-codereview-commit__commit',
            '#ghx-tab-com-xiplink-jira-git-jira_git_plugin-agile-git-commits',
            '#THIRD_PARTY_TAB-nav:has([href="#ghx-tab-com-xiplink-jira-git-jira_git_plugin-agile-git-commits"])',
            getMainNavigationToErase('/secure/bbb.gp.gitviewer.AllRepositories.jspa'),
            getProjectNavigationToErase('com.xiplink.jira.git.jira_git_plugin:git-project-view'),
            getTabsToErase(['[data-id="git-summary-tabpanel"]', '[data-id="git-commits-tabpanel"]'])
        );
    }

    function eraseStructure() {
        eraseBySelector(
            getMainNavigationToErase('/secure/StructureBoard.jspa'),
            getProjectNavigationToErase('com.almworks.jira.structure:wi-projectnav-structure'),
        );
    }

    function eraseCapture() {
        eraseBySelector(
            '#THIRD_PARTY_TAB-nav:has([href="#ghx-tab-com-atlassian-bonfire-plugin-bonfireGFWebPanel"])',
            '#ghx-tab-com-atlassian-bonfire-plugin-bonfireGFWebPanel',
            getMainNavigationToErase('/secure/SessionNavigator.jspa'),
            getProjectNavigationToErase('com.atlassian.bonfire.plugin:capture-test-sessions'),
        );
    }

    function eraseBoards() {
        eraseBySelector(
            '#greenhopper-agile-issue-web-panel',
            '#opsbar-operations_more_drop .aui-dropdown2-section:has(#greenhopper-rapidboard-operation)',
            '#user-options-content li:has(#greenhopper-my-jira-home-set)',
            getMainNavigationToErase('/secure/RapidBoard.jspa'),
            getProjectNavigationToErase(['com.pyxis.greenhopper.jira:project-sidebar-plan-scrum', 'com.pyxis.greenhopper.jira:project-sidebar-work-scrum']),
        );
    }

    function eraseVotes() {
        eraseBySelector(
            '#peoplemodule .item-details dl:has(a[href*="/secure/ViewVoters!default.jspa?id"])',
            '#peoplemodule .item-details dl:has(a#vote-toggle)',
            '#opsbar-operations_more_drop li:has(#view-voters)',
            '#opsbar-operations_more_drop li:has(a#toggle-vote-issue)',
        );
    }

    function eraseWatching() {
        eraseBySelector(
            '#peoplemodule .item-details dl:has(#view-watcher-list)',
            '#opsbar-operations_more_drop li:has(#toggle-watch-issue)',
            '#opsbar-operations_more_drop li:has(#manage-watchers)',
        );
    }

    function eraseTimeTracking() {
        eraseBySelector(
            '#opsbar-operations_more_drop .aui-dropdown2-section:has(#log-work)',
        );
    }

    function getTabsToErase(items) {
        if (!Array.isArray(items)) {
            items = [items];
        }
        let selectors = [];
        for (let tab of items) {
            selectors.push('#issue-tabs li' + tab);
        }
        return selectors;
    }

    function getMainNavigationToErase(items) {
        if (!Array.isArray(items)) {
            items = [items];
        }
        let selectors = [];
        for (let navigationItem of items) {
            selectors.push('nav .aui-header-primary li:has(> a[href="' + navigationItem + '"] )');
            selectors.push('#aui-responsive-header-dropdown-list-0 aui-item-link[href="' + navigationItem + '"]');
        }
        return selectors;
    }

    function getProjectNavigationToErase(items) {
        if (!Array.isArray(items)) {
            items = [items];
        }
        let selectors = [];
        for (let navigationItem of items) {
            selectors.push('.aui-sidebar-body .aui-navgroup-vertical .aui-nav li:has([data-link-id="' + navigationItem + '"])');
        }
        return selectors;
    }

    function eraseBySelector(...selectors) {
        let selectorsCollection = [];
        for (let selector of selectors) {
            if (!Array.isArray(selector)) {
                selector = [selector];
            }
            selectorsCollection = selectorsCollection.concat(selector);
        }
        let styles = selectorsCollection.join(',') + ' {display:none !important}';
        utils.writeStyles(styles);
    }

    return {
        eraseTeamCity,
        eraseZephyr,
        eraseGant,
        eraseGit,
        eraseStructure,
        eraseCapture,
        eraseBoards,
        eraseVotes,
        eraseWatching,
        eraseTimeTracking,

        eraseBySelector,
        getTabsToErase,
        getMainNavigationToErase,
        getProjectNavigationToErase,
    }
}

const eraser = new Eraser();