function JiraCopy() {

    let _selectors = {
        issue: {
            numberLink: 'div.aui-page-header-main #key-val',
            title: 'h1#summary-val',
        },
        rapid: {
            numberLink: 'div.js-view-in-jira #issuekey-val',
            title: '.ghx-detail-summary #summary-val',
        }
    };

    function injectIssueCopyButtons() {
        if ($('.plugin-issue-copy').length) {
            return;
        }
        let $numberLink = $(_selectors.issue.numberLink);
        let $titleNode = $(_selectors.issue.title);
        if (!$numberLink.length) {
            $numberLink = $(_selectors.rapid.numberLink);
            $titleNode = $(_selectors.rapid.title);
        }
        let number = $numberLink.text().trim();
        let title = $titleNode.text().trim();

        let $wrapper = $('<span class="plugin-issue-copy">Copy:</span>');
        _generateButtons(number, title, $wrapper);
        $wrapper.insertAfter($numberLink);
    }

    function injectBoardCopyButtons() {
        let $issueList = $('.js-detailview.ghx-issue.js-issue:not(.plugin-board-copy)');
        for (const issueNode of $issueList) {
            const $issue = $(issueNode);
            $issue.addClass('plugin-board-copy');
            const number = $issue.attr('data-issue-key');
            const title = $issue.find('.ghx-issue-content .ghx-issue-fields .ghx-summary').text().trim();
            const $wrapper = $('<div class="copier"></div>');
            _generateButtons(number, title, $wrapper, true);
            $wrapper.insertAfter($issue.find('.ghx-flags'));
        }

    }

    function _generateButtons(number, title, $wrapper, short) {
        short = typeof short === 'undefined' ? false : short;

        if (!short) {
            $('<span>#</span>').on('click', function (event) {
                utils.copyTextToClipboard(number);
                event.preventDefault();
                event.stopPropagation();
            }).appendTo($wrapper);
            $('<span>T</span>').on('click', function (event) {
                utils.copyTextToClipboard(title);
                event.preventDefault();
                event.stopPropagation();
            }).appendTo($wrapper);
        }
        $('<span>#T</span>').on('click', function (event) {
            utils.copyTextToClipboard(number + ' ' + title);
            event.preventDefault();
            event.stopPropagation();
        }).appendTo($wrapper);
        $('<span><span class="aui-icon aui-icon-small aui-iconfont-link"></span>T</span>').on('click', function (event) {
            utils.copyTextToClipboard(window.location.origin + '/browse/' + number + ' ' + title);
            event.preventDefault();
            event.stopPropagation();
        }).appendTo($wrapper);
    }

    return {
        injectIssueCopyButtons,
        injectBoardCopyButtons,
    }
}

const jiraCopy = new JiraCopy();
