function Utils() {

    async function wait(conditionCallback, timeout) {
        timeout = timeout === undefined ? 100 : timeout;
        return new Promise((resolve) => {
            let checkCondition = function () {
                if (conditionCallback()) {
                    resolve();
                }
                setTimeout(checkCondition, timeout);
            }
            checkCondition();
        });
    }

    function getQuery(variable, url) {
        url = typeof url === 'undefined' ? window.location.search : url;
        if (url.indexOf('http') === 0) {
            const l = document.createElement("a");
            l.href = url;
            url = l.search
        }
        const query = url.substring(1);
        const vars = query.split('&');
        const params = {};
        for (let i = 0; i < vars.length; i++) {
            const pair = vars[i].split('=');
            const name = decodeURIComponent(pair[0]).trim();
            if (name.length === 0) {
                continue;
            }
            if (name === variable) {
                return decodeURIComponent(pair[1]);
            }
            params[name] = pair[1];
        }
        if (variable) {
            return null;
        }
        return params;
    }

    function buildQuery(params) {
        let parts = [];
        for (let param in params) {
            parts.push(encodeURIComponent(param) + '=' + encodeURIComponent(params[param]));
        }
        return parts.join('&');
    }

    async function copyTextToClipboard(text) {
        const type = "text/plain";
        const blob = new Blob([text], {type});
        await navigator.clipboard.write([
            new ClipboardItem({
                [blob.type]: blob
            })
        ])
    }

    function arrayUnique(arrayToProcess) {
        return arrayToProcess.filter((value, index, array) => {
            return array.indexOf(value) === index;
        });
    }

    function writeStyles(styles, attributes, target) {
        const $style = $('<style>' + styles + '</style>');
        if (typeof attributes === 'object') {
            for (let attr in attributes) {
                $style.attr(attr, attributes[attr]);
            }
        }
        target = typeof target === "undefined" ? 'head' : target;
        $style.prependTo(target);

    }

    function eraseBySelector(...selectors) {
        let selectorsCollection = [];
        for (let selector of selectors) {
            if (!Array.isArray(selector)) {
                selector = [selector];
            }
            selectorsCollection = selectorsCollection.concat(selector);
        }
        let styles = selectorsCollection.join(',') + ' {display:none !important}';
        writeStyles(styles);
    }

    return {
        getQuery,
        buildQuery,
        wait,
        copyTextToClipboard,
        arrayUnique,
        writeStyles,
        eraseBySelector,
    };
}

const utils = new Utils();