function Dev() {

    let _mode = false;

    _init();

    function _init() {
        _mode = window.location.protocol === 'chrome-extension:' ? 'extension' : 'page';
        _listenLogs();
    }

    /**
     * отправка во все консоли сообщения из любой части приложения
     * @param dataToLog
     */
    function log(...dataToLog) {
        let fakeError = new Error();
        let trace = /\((\S+)\)/gm.exec(fakeError.stack.split("\n")[2].trim())[1];
        let data = {
            message: dataToLog,
            from: _mode, //из какой части приложения отправляется сообщение
            trace: trace, //из какого файла и строки отправляется сообщение
            random: Math.random(), //немного рандома для насильного обновления хранилища даже при повторяющемся сообщении
        };
        chrome.storage.local.set({devLog: data});
    }

    function _listenLogs() {
        chrome.storage.local.onChanged.addListener(function (changes) {
            if (changes.devLog === undefined || !changes.devLog.newValue) {
                return;
            }
            const event = changes.devLog.newValue;
            console.group(event.from + ' > ' + event.trace);
            console.log(...event.message);
            console.groupEnd();
            chrome.storage.local.set({devLog: null});
        });
    }


    return {
        log
    }
}

const dev = new Dev();