function project_page() {
    _init();

    function _init() {
        navigationInRepo.removeUnnecessary();
        _showMRCountInCollapsed();
    }

    function onReady() {
        navigationInRepo.addNeedle();
        jiraAndBrIssue.update();
        favorite.updateProjectMainPage();
    }

    function _showMRCountInCollapsed() {
        if (settings.get('inRepo_showMRCountInCollapsed')) {
            utils.writeStyles(
                '.nav-sidebar-inner-scroll {' +
                '    overflow: visible !important;' +
                '}' +
                '.nav-sidebar-inner-scroll li[data-track-label="merge_requests_menu"] {' +
                '    position: relative !important;' +
                '}' +
                '.nav-sidebar.sidebar-collapsed-desktop .badge.badge-pill:not(.fly-out-badge) {' +
                '    display: block !important;' +
                '    width: auto !important;' +
                '    height: 16px !important;' +
                '    padding: 0 5px !important;' +
                '    top: 0 !important;' +
                '    right: 0 !important;' +
                '    clip: auto !important;' +
                '}'
            );
        }

    }

    return {onReady};
}