function mergeRequestsList_page() {

    _init();

    function _init() {
        _colorConflict();
        _insertIcons();
    }

    function onReady() {
        _colorDraft();
    }

    function _colorDraft() {
        if (settings.get('mr_color_draft')) {
            $('.merge-request-title a.js-prefetch-document').each(function () {
                const $a = $(this);
                if ($a.text().startsWith('Draft: ')) {
                    $a.addClass('plugin-mr-draft');
                }
            });
        }
    }

    function _colorConflict() {
        if (settings.get('mr_color_conflict')) {
            utils.writeStyles(
                '.merge-request:has(.issuable-pipeline-broken) .merge-request-title-text a {' +
                '    color: #c96f6f !important;' +
                '}');
        }
    }

    function _insertIcons() {
        if (settings.get('mr_add_icons')) {
            utils.writeStyles('.plugin-mr-draft::before {' +
                '    content: "❔❕";' +
                '}' +
                '.merge-request:has(.issuable-pipeline-broken) .merge-request-title-text a:first-of-type::before {' +
                '    content: "⚠";' +
                '}' +
                '.merge-request:has(.issuable-pipeline-broken) .merge-request-title-text a.plugin-mr-draft::before {' +
                '    content: "❔❕⚠";' +
                '}' +
                '.merge-request:has([data-testid="approval-solid-icon"]) .merge-request-title-text::before,' +
                '.merge-request:has([data-testid="approval-icon"]) .merge-request-title-text::before {' +
                '    content: "✔";' +
                '}'
            );
        }
    }

    return {onReady};
}