function inMergeRequest_page() {

    _init();

    function _init() {

    }

    function onReady() {
        _setKeyboardHandler();
        _updateMRBranchLink();
        _colorizeHeader();
    }

    function _setKeyboardHandler() {
        $(document).on('keydown', (evt) => {
            if (evt.altKey && evt.code === 'ArrowUp') {
                let path = window.location.pathname.split('/');
                window.location.pathname = path.slice(0, path.length - 1).join('/');
            }
        });
    }

    function _colorizeHeader() {
        if (settings.get('mr_color_draft')) {
            $('.detail-page-description h2.title').each(function () {
                const $h2 = $(this);
                if ($h2.text().trim().startsWith('Draft: ')) {
                    $h2.addClass('plugin-mr-draft');
                }
            });
        }
    }

    function _updateMRBranchLink() {
        utils.wait(_checkIfMRLoaded)
            .then(jiraAndBrIssue.update);
    }

    function _checkIfMRLoaded() {
        let mrTitleDiv = $('.mr-source-target strong');
        let mrCommitsList = $('#commits ul');
        let mrDiffs = $('#diffs');
        return mrTitleDiv.length > 0 || mrCommitsList.length > 0 || mrDiffs.length > 0;

    }

    return {onReady};
}