function branches_page() {

    _init();

    function _init() {

    }

    function onReady() {
        _recallPage();
        _updateMRButtons();
        _switchGraphs();
        _reduceGraphs();
        _hideButtons();
        _improveDeletion();
    }

    function _updateMRButtons() {
        if (!settings.get('branches_updateMRButtons')) {
            return;
        }
        $('a[href*="/-/merge_requests/new"]').each((index, link) => {
            $(link)
                .html('<span class="nav-icon-container">' + icons.get('git-merge', ['s16']) + '</span>')
                .addClass('has-tooltip')
                .attr('title', 'Создать запрос на слияние')
                .css({'margin-right': '0.5rem'});
        });
    }

    function _switchGraphs() {
        if (!settings.get('branches_switchGraphs')) {
            return;
        }
        $('ul.all-branches li.branch-item .js-branch-divergence-graph').each((index, graph) => {
            //стили ниже нельзя ставить через css файл, т.к. пользователь может не желать этого улучшения.
            let $graph = $(graph).css({width: '80px'});
            $graph.parent().prepend($graph);
        });
    }

    async function _reduceGraphs() {
        if (!settings.get('branches_reduceGraphs')) {
            return;
        }
        // обновлять графы надо после того, как их нарисует гитлабовский встроенный скрипт
        await utils.wait(_checkGraphExists, 30);

        $('ul.all-branches li.branch-item .divergence-graph').each((index, graph) => {
            //стили ниже нельзя ставить через css файл, т.к. пользователь может не желать этого улучшения.
            let $graph = $(graph).removeClass('px-2');
            $graph.find('.graph-side').css({width: '40px'});
        });
    }

    function _hideButtons() {
        if (!settings.get('branches_hideButtons')) {
            return;
        }
        $('.controls').addClass('hide-not-hovered');
    }

    function _checkGraphExists() {
        if (!$('ul.all-branches li.branch-item').length) {
            return true;
        }
        return $('.divergence-graph').length > 0;
    }

    function _improveDeletion() {
        if (!settings.get('branches_improveDeletion')) {
            return;
        }
        //если мы на общей вкладке веток, нет смысла в псевдоаякс удалении
        if (window.location.pathname.indexOf('/-/branches/') === -1) {
            return;
        }

        let query = utils.getQuery();
        query.page = parseInt(query.page ?? '1');
        //если на странице всего 1 ветка
        if (query.page !== 1 && $('main ul.all-branches li').length === 1) {
            query.page--;
        }

        const newPage = window.location.origin + window.location.pathname + '?' + utils.buildQuery(query) + window.location.hash;
        $('body').on('click', 'button[data-qa-selector="delete_branch_confirmation_button"]', () => {
            _memorizePage(newPage);
        });
    }

    function _recallPage() {
        chrome.storage.local.get(['branchesPageAfterReload'], function (result) {
            if (result.branchesPageAfterReload) {
                $('body').html('Return to branches page');
                const page = result.branchesPageAfterReload;
                chrome.storage.local.set({branchesPageAfterReload: false});
                window.location = page;
            }
        });
    }

    function _memorizePage(page) {
        chrome.storage.local.set({branchesPageAfterReload: page});
    }

    return {onReady};
}