function NavigationInRepo() {

    let _basePath = '';

    //TODO: сделать в настройках возможность скрывать/показывать пункты, а не хардкодить список
    let _unnecessaryList = [
        'security_compliance_menu',
        'issues_menu',
        'infrastructure_menu',
        'packages_registries_menu',
        'monitor_menu',
        'wiki_menu',
        'snippets_menu',
    ];

    let _addList = [
        {
            name: "Members",
            href: "project_members",
            'data-qa-menu-item': "Members",
            icon: 'users',
            after: 'project_information_menu',
        },
        {
            name: "Branches",
            href: "branches",
            'data-qa-menu-item': "branches",
            icon: 'branch',
            after: 'repository_menu',
        },
    ];

    let _itemTemplate = '<li data-track-label="project_information_menu" class="{{item.isActive}}">' +
        '<a aria-label="{{item.name}}" class="gl-link" data-qa-selector="sidebar_menu_link" data-qa-menu-item="{{item.data-qa-menu-item}}" href="{{item.href}}">' +
        '    <span class="nav-icon-container">' +
        '        {{{item.svg}}}' +
        '    </span>' +
        '    <span class="nav-item-name">' +
        '        {{item.name}}' +
        '    </span>' +
        '</a>';

    const _listSelector = 'ul[data-qa-selector="project_sidebar"]';

    _detectUrl();

    function removeUnnecessary() {
        if (!settings.get('inRepo_removeUnnecessaryNavi')) {
            return;
        }
        let selectors = [];
        for (let unnecessary of _unnecessaryList) {
            selectors.push(_listSelector + ' li[data-track-label="' + unnecessary + '"]');
        }
        utils.eraseBySelector(selectors);
    }

    function addNeedle() {
        if (!settings.get('inRepo_addNeedleNavi')) {
            return;
        }
        const $list = $(_listSelector);
        for (let item of _addList) {
            item.svg = icons.get(item.icon, ['s16'])
            item.href = _basePath + '/-/' + item.href;
            item.isActive = item.href === window.location.pathname ? 'active' : '';
            let html = $(Mustache.to_html(_itemTemplate, {item}));
            if (item.after) {
                let before = $list.find('li[data-track-label="' + item.after + '"]');
                if (before) {
                    before.after(html);
                    continue;
                }
            }
            $(html).appendTo($list);
        }
    }

    function _detectUrl() {
        if (window.location.pathname.indexOf('/-/') === -1) {
            _basePath = window.location.pathname;
        } else {
            _basePath = window.location.pathname.substring(0, window.location.pathname.indexOf('/-/'));
        }
    }

    return {
        removeUnnecessary,
        addNeedle,
    };
}

var navigationInRepo = new NavigationInRepo();