function JiraAndBrIssue() {
    const _jiraBasePath = 'https://jira.srvdev.ru/browse/';
    const _brBasePath = 'https://br.srvdev.ru/issues/';

    const _jiraBranchRegexp = /^dev\/(([A-Z])+-([0-9])+)/gm;
    const _jiraCommitRegexp = /^(([A-Z])+-([0-9])+)/gm;
    const _brBranchRegexp = /^dev[\/\-]([0-9]+)/gm;
    const _brCommitRegexp = /^#([0-9]+)/gm;

    //TODO: это можно разрулить через css
    const _jiraIcon = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAI3SURBVDhPY5T3b2SAgf///wNJJkbGF+8+AxkSQrz/wCKMjIwgaTBggtJg8PHL989ffzx7+2nf1GwgAjKAXKAgVBoMEBqevvpwc3X13XV1vz585eVi4+PmADLurq8FCgKloIoYGFgg1N9///7++7/+4CWgM/jE+G3TJwMFgYz9Z++8fv8FKAVUwMwEMh3kByBHgIczxsO4cc6uH79+S4nyf/j8DSgnwMv17PVHTnbW2iS3pTvPfvjyHagH7KT/DD9//ymPc/l2qCvc1ZCHk23vlCwg4uViB3K/HuyqiHf59fsPUBkQgDQwMzM9fP7+wLnbQPb82sibN5+ICvKICvLeuPEYyAUKHjx/9/7zd0BlQDY0WP/8/QcMusebGoDse0/fKHvWAhl3tzcrSYsAGbJ+DcDgZQFrADsJ6Hdmpq/ff7nlTQeygYqOLys/vrQcototfzpQCqIaCJgFNBwhLHY2lusPXj5788nbWktGTEBGXAAomNOzduPBy0L83BA1QIDQAATcnOx7Tt549+m7p5UmkLv/9K2clhXSUkIQWQhA0fD9528/O50bD14Cw8DRRFVRWvjSg5d3n75hZWGGqkBLGq8/fFlYF31kdn7/ygOnrj4Eiixtin3z8StEFgIQGoAhba2nyMoKMkxBUii4Yj6QAYw1oCAoEmAAoQEYshba8kAGMC3cf/YOGK9ABpBroSMPlAIrAQGU5P3p64/3bz4ysLHKSQgCuY9evAfaKyjCD0yIEAUMDAwABbv7FYAlXWYAAAAASUVORK5CYII=';
    const _brIcon = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAG1SURBVDhPdZLNSwJBGMbfEPEDnQU9hJBonUujulQnoahbbociqD8l6M/QSxFEH5a7rcHaB32ZFUSHuhYJkUFFhyKCxGR7ZmfZVGp4WOad9/e878zskCpJ9VLwZSzr9UIKYzxs1K8BOcXnA7RCpIXbcuEwJtzj89kMZBmQ2HA61WBgkejbsEa1VkOoBoJI2a1MA2iXK98dB3Q1O3s6NSUMxYnJ67k5TPR4LOtyCQ8MDOWXiASEoUWj+4nEQSKhtbdbS4YBAHXh4bvMEBXk5ALR5+Pj8VgSIRpCmByPj3+Uy0gVZDlDLYAp63bn4zHUqFa+tnt7AKnM2q6otdPXV61UAOidXYBpjeghp5ltjcOhYRQWtBDCo5FRkb3fVAFT1uOZJ9obHHgvlZbNe6w3IMTlvpXudgf6gQGmrQ5+srKunyTldYfD3o9twOKJLJf1PLBcNErnMzNmQ+Pl4mIVB6ijuZiExdfLS8GcTU/TTTotgqdC4T/Dc7EomNtUijZbW7VIhCsUanoFQlhESjCACbH11P6iheoZ/v9Uya8yvyKxphPbMq/Ob2KM+CMV4nTDnQqJQhYjST+AhDJjB81IUQAAAABJRU5ErkJggg==';

    let _timer = false;

    let _linksSelectors = {
        branch: [
            '[href*="/-/tree/"]'
        ],
        mr: [
            '[href*="/-/merge_requests/"]'
        ],
        commit: [
            '[href*="/-/commits/"]',
            '[href*="/-/commit/"]'
        ],
    };

    let _textSelectors = {
        mr: [
            '.merge-request-details h2'
        ],
        branch: [
            'span.js-source-branch'
        ],
    };

    function update() {
        if (_timer) {
            clearTimeout(_timer);
            _timer = false;
        }

        _updateLinksBySettings();
        _updateNativeLinks();

        _timer = setTimeout(update, 5000);
    }

    function _updateLinksBySettings() {
        if (settings.get('trackers_branch')) {
            for (let selector of _linksSelectors.branch) {
                _updateLinks(selector);
            }
            for (let selector of _textSelectors.branch) {
                _updateText(selector);
            }
        }
        if (settings.get('trackers_commit')) {
            for (let selector of _linksSelectors.commit) {
                _updateLinks(selector);
            }
        }
        if (settings.get('trackers_mr')) {
            for (let selector of _linksSelectors.mr) {
                _updateLinks(selector);
            }
            for (let selector of _textSelectors.mr) {
                _updateText(selector);
            }
        }
    }

    function _updateLinks(selector) {
        let $links = $('a' + selector + ':not([plugin_processed])');
        $links.each((i, link) => {
            let $link = $(link);
            $link.attr('plugin_processed', '1');
            [text, originalText] = _prepareText($link);
            let issue = _matchTextWithIssue(text);
            if (!issue) {
                return;
            }
            let icon = issue.type === 'jira' ? _jiraIcon : _brIcon;
            _getLink(issue.href, icon).insertBefore($link);
        });
    }

    function _updateText(selector) {
        let $nodes = $(selector + ':not([plugin_processed])');
        $nodes.each((i, node) => {
            let $node = $(node);
            $node.attr('plugin_processed', '1');
            if ($node.find('a').length) {
                return;
            }
            [text, originalText] = _prepareText($node);
            let issue = _matchTextWithIssue(text);
            if (!issue) {
                return;
            }
            let link = _getLink(issue.href, null, issue.matched);
            let html = originalText.replace(issue.matched, link[0].outerHTML);
            $node.html(html);
        });
    }

    /**
     * добавим сылкам на жиру, которые расставили не мы, перевод и аттрибут что бы они открывались в новом окне
     * @private
     */
    function _updateNativeLinks() {
        if (!settings.get('trackers_fix_native')) {
            return;
        }
        let $links = $('a[href^="https://jira."]:not([plugin_jira_link][plugin_processed])');
        $links.each((i, link) => {
            let $link = $(link);
            $link.attr('plugin_processed', '1').attr('target', '_blank').attr('title', 'Перейти к задаче');
        });
    }

    function _prepareText($node) {
        let originalText = $node.text().trim();
        let text = $node.text().trim();
        if (text.indexOf('Draft: ') === 0) {
            text = text.substring(7);
        }
        return [text, originalText];
    }

    function _matchTextWithIssue(text) {
        if (settings.get('trackers_jira')) {
            _jiraBranchRegexp.lastIndex = 0;
            let branchMatch = _jiraBranchRegexp.exec(text);
            if (branchMatch !== null) {
                let href = _jiraBasePath + branchMatch[1];
                return {type: 'jira', matched: branchMatch[1], href};
            }
            _jiraCommitRegexp.lastIndex = 0;
            let commitMatch = _jiraCommitRegexp.exec(text);
            if (commitMatch !== null) {
                let href = _jiraBasePath + commitMatch[1];
                return {type: 'jira', matched: commitMatch[1], href};
            }
        }
        if (settings.get('trackers_br')) {
            _brBranchRegexp.lastIndex = 0;
            let brBranchMatch = _brBranchRegexp.exec(text);
            if (brBranchMatch !== null) {
                let href = _brBasePath + brBranchMatch[1];
                return {type: 'br', matched: brBranchMatch[1], href};
            }
            _brCommitRegexp.lastIndex = 0;
            let brCommitMatch = _brCommitRegexp.exec(text);
            if (brCommitMatch !== null) {
                let href = _brBasePath + brCommitMatch[1];
                return {type: 'br', matched: brCommitMatch[1], href};
            }
        }
        return false;
    }

    //TODO: перевести бы на шаблон mustache может
    function _getLink(href, icon, text) {
        let $link = $('<a>')
            .attr('href', href)
            .attr('target', '_blank')
            .addClass('plugin-jira-link')
            .addClass('has-tooltip')
            .attr('plugin_jira_link', 1)
            .attr('title', 'Перейти к задаче');
        if (icon) {
            let $img = $('<img>').attr('src', icon);
            $link.append($img);
        }
        if (text) {
            $link.append(text);
        }
        return $link;
    }

    _init();

    function _init() {

    }

    return {update};
}

var jiraAndBrIssue = new JiraAndBrIssue();