function Favorite() {

    let _favorites = [];
    let _ready = false;

    let _menuTemplate =
        '<li class="nav-item b-nav-dropdown dropdown gl-new-dropdown" id="__PLUGIN_FAVORITE_MENU">' +
        '   <a aria-haspopup="true" aria-expanded="true" href="#" target="_self" role="button" class="top-nav-toggle" id="__PLUGIN_FAVORITE_MENU__BV_toggle_">' +
        '   ' + icons.get('star', ['s16', 'icon', 'dropdown-icon']) +
        '       Избранное' +
        '   </a>' +
        '   <ul tabindex="-1" ' +
        '       class="dropdown-menu gl-mt-3! gl-max-w-none! gl-max-h-none! gl-sm-w-auto! js-top-nav-dropdown-menu" ' +
        '       aria-labelledby="__PLUGIN_FAVORITE_MENU__BV_toggle_" ' +
        '   >' +
        '       <li role="presentation">' +
        '           <div tabindex="-1" class="b-dropdown-form gl-p-0">' +
        '               <ul id="plugin-favorite_menu_area" class="list-unstyled"></ul>' +
        '           </div>' +
        '       </li>' +
        '   </ul>' +
        '</li>';

    let _menuItemTemplate =
        '<li class="frequent-items-list-item-container">' +
        '   <a href="{{ favorite.path }}" class="btn gl-text-left gl-justify-content-start! btn-default btn-md gl-button btn-default-tertiary">' +
        '       <span class="gl-button-text">' +
        '           {{^ favorite.image }}' +
        '               <div class="gl-float-left gl-mr-3 gl-avatar gl-avatar-identicon gl-avatar-s32 gl-avatar-identicon-{{ favorite.className }}" aria-hidden="true">' +
        '                   {{ favorite.letter }}' +
        '               </div>' +
        '           {{/ favorite.image }}' +
        '           {{# favorite.image }}' +
        '               <img src="{{ favorite.image }}" alt="{{ favorite.name }}" class="gl-float-left gl-mr-3 gl-avatar gl-avatar-s32" aria-hidden="true">' +
        '           {{/ favorite.image }}' +
        '           <div class="frequent-items-item-metadata-container">' +
        '               <div title="{{ favorite.name }}">{{ favorite.name }}</div>' +
        '               <div title="{{ favorite.breadcrumbsString }} / {{ favorite.name }}">{{ favorite.breadcrumbsString }}</div>' +
        '           </div>' +
        '       </span>' +
        '   </a>' +
        '</li>';

    let _toggleIconTemplate =
        '<span ' +
        '   id="plugin-favorite_toggle" ' +
        '   class="plugin-favorite-icon {{# isFavorite }}plugin-favorite-icon-active{{/ isFavorite }}"' +
        '>' +
        '   {{{ icon }}}' +
        '</span>';

    _init();

    function _init() {
        _load();
    }

    async function injectMenu() {
        if (
            !settings.get("global_favorites")
            || $('#__PLUGIN_FAVORITE_MENU').length
        ) {
            return;
        }
        let selector = '.header-content .title-container ul.nav.navbar-sub-nav';
        await utils.wait(() => $(selector).length);
        let $menu = $(_menuTemplate);
        $menu
            .appendTo(selector)
            .find('#__PLUGIN_FAVORITE_MENU__BV_toggle_')
            .on('click', () => {
                $menu.toggleClass('show');
            });
        $('body').on('click', (event) => {
            if (!event.target.closest('#__PLUGIN_FAVORITE_MENU')) {
                $menu.removeClass('show');
            }
        });
        _drawFavoritesMenu();
    }

    function _drawFavoritesMenu() {
        let $area = $('#plugin-favorite_menu_area');
        $area.html('');
        _favorites.sort((favoriteA, favoriteB) => {
            return favoriteA.name > favoriteB.name ? 1 : -1;
        });
        for (let favorite of _favorites) {
            let drawFavorite = {...favorite};
            drawFavorite.letter = favorite.name.substring(0, 1).toUpperCase();
            drawFavorite.breadcrumbsString = favorite.breadcrumbs.join(' / ');
            let $li = $(Mustache.to_html(_menuItemTemplate, {favorite: drawFavorite}));
            $li.appendTo($area);
        }
    }

    async function updateProjectMainPage() {
        if (
            !settings.get("global_favorites")
            || window.location.pathname.indexOf('/-/') !== -1
            || $('#plugin-favorite_toggle').length
        ) {
            return;
        }
        await utils.wait(() => _ready);

        //Обновить можем только главную страницу проекта, не группы
        const $h1 = $('.project-home-panel h1');
        if (!$h1.length) {
            return;
        }

        const isFavorite = _favorites.filter((record) => {
            return record.path === window.location.pathname;
        }).length === 1;


        let $favoriteSpan = $(Mustache.to_html(_toggleIconTemplate, {
            icon: icons.get(isFavorite ? 'star' : 'star-o', ['s24', 'icon']),
            isFavorite
        }))
            .on('click', _toggleIsProjectFavorite);

        $h1.before($favoriteSpan);
    }

    function _toggleIsProjectFavorite() {
        let projectIndex = -1;
        for (let index in _favorites) {
            if (_favorites[index].path === window.location.pathname) {
                projectIndex = index;
                break;
            }
        }
        if (projectIndex !== -1) {
            _favorites.splice(projectIndex, 1);
        } else {
            _favorites.push(_getProjectFromPage());
        }
        $('#plugin-favorite_toggle').remove();
        updateProjectMainPage();
        _save();
    }

    function _getProjectFromPage() {
        const $breadcrumbs = $('[data-qa-selector="breadcrumb_links_content"] li');
        let breadcrumbs = [];
        $breadcrumbs.each((index, node) => {
            if (index === $breadcrumbs.length - 1) {
                return;
            }
            let text = $(node).text().trim();
            if (text.length) {
                breadcrumbs.push(text);
            }
        });
        const $avatarContainer = $('.project-home-panel .avatar-container');
        const $img = $avatarContainer.find('img');
        const image = ($img.length) ? $img.attr('src') : null;
        const className = ($img.length)
            ? null
            : $avatarContainer
                .find('span')
                .attr('class')
                .split(/\s+/)
                .filter(className => className.indexOf('bg') === 0)[0];
        return {
            path: window.location.pathname,
            name: $('.project-home-panel h1').text().trim(),
            breadcrumbs,
            image,
            className
        };
    }

    function _load() {
        chrome.storage.local.get(['favorites'], function (result) {
            if (result.favorites) {
                _favorites = result.favorites;
            }
            _ready = true;
        });
    }

    function _save() {
        chrome.storage.local.set({favorites: _favorites});
        _drawFavoritesMenu();
    }

    return {
        injectMenu,
        updateProjectMainPage
    };
}

const favorite = new Favorite();
