(function () {

    function getManifestKey(key) {
        const manifest = chrome.runtime.getManifest();
        return manifest[key];
    }

    const listener = (details) => {
        if (details.documentLifecycle !== "active") {
            return;
        }
        chrome.management.getAll(async function (extensions) {
            for (const ext of extensions) {
                if (
                    (ext.installType === 'development')
                    && (ext.enabled === true)
                    && (ext.name !== 'Plugin devtools')
                ) {
                    const extensionId = ext.id;
                    chrome.management.setEnabled(extensionId, false, () => {
                        chrome.management.setEnabled(extensionId, true);
                    });

                    // re-launch packaged app
                    if (ext.type === 'packaged_app') {
                        chrome.management.launchApp(extensionId);
                    }

                    console.log(ext.name + ' reloaded');
                }
            }
        });
    };
    const networkFilter = {
        urls: getManifestKey('host_permissions'),
        types: ['main_frame']
    };

    chrome.webRequest.onBeforeRequest.addListener(listener, networkFilter);

}());